import rme.security.SecureConfigurator;
import rme.SNService.SecureLookupService;

import arcademis.security.Key;
import arcademis.security.Signature;

import java.util.StringTokenizer;
import java.io.*;

public class KeyBinder {
    public static void main(String a[]) throws Exception {
        if (a.length == 0) {
            System.err.println("Sintax: java KeyBinder file-name [host-name]");
            System.exit(1);
        } else {
            SecureConfigurator c = new SecureConfigurator();
            c.configure();

            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(a[0]));
            Key pubKey, prvKey;
            Signature signature;
            try {
                while(true) {
                    signature = (Signature)ois.readObject();
                    System.out.println("Signature: " + signature);
                    pubKey = (Key)ois.readObject();
                    System.out.println("Public key: " + pubKey);
                    prvKey = (Key)ois.readObject();
                    System.out.println("Private key: " + prvKey);
                    if(a.length > 1) {
                        arcademis.concreteComponents.ParsedURL url = new arcademis.concreteComponents.ParsedURL(a[1] + "/" + "manfredine");
                        System.out.println(url.toString());
                        SecureLookupService.debut(a[1] + "/" + "manfredine", signature, pubKey);
                    }
                    else
                        SecureLookupService.debut(signature, pubKey);
                }
            } catch (EOFException e) {
                System.out.println("Reached end of file");
                ois.close();
            }
        }
    }
}
