import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class InvocationPanel extends JPanel implements ActionListener {

    private Mediator mediator;

    private JTextArea textArea;
    private JButton getAbstractButton;
    private JButton getFullButton;
    private JButton sendReviewButton;
    private JButton updateButton;
    private JButton cleanButton;

    public InvocationPanel(Mediator mediator) {

        this.mediator = mediator;

        // Creating the button panel
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.PAGE_AXIS));

        getAbstractButton   = new JButton("view abstract");
        getAbstractButton.addActionListener(this);
        buttonPanel.add(getAbstractButton);

        getFullButton       = new JButton(" view article  ");
        getFullButton.addActionListener(this);
        buttonPanel.add(getFullButton);

        sendReviewButton = new JButton(" send review ");
        sendReviewButton.addActionListener(this);
        buttonPanel.add(sendReviewButton);

        updateButton     = new JButton("update paper");
        updateButton.addActionListener(this);
        buttonPanel.add(updateButton);

        cleanButton      = new JButton("  erase text   ");
        cleanButton.addActionListener(this);
        buttonPanel.add(cleanButton);

        buttonPanel.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createLoweredBevelBorder(),
                        BorderFactory.createEmptyBorder(5,5,5,5))
        );

        this.add(buttonPanel, BorderLayout.EAST);

        // Creating the text box with the scroll panel
        textArea = new JTextArea(10, 40);
        JScrollPane scrollPane = new JScrollPane(textArea);
        this.add(scrollPane, BorderLayout.CENTER);

        this.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder("Read/Write Paper"),
                        BorderFactory.createEmptyBorder(5,5,5,5))
        );
    }


    public void actionPerformed(ActionEvent e) {
        try {
            if(mediator.paper == null) {
                JOptionPane.showMessageDialog(null, "No connection to remote object.", "Input error", JOptionPane.ERROR_MESSAGE);
            } else if(e.getSource() == this.getAbstractButton) {
                this.textArea.setText(mediator.paper.getAbstract());
                mediator.statusBar.setText("Paper abstract loaded.");
            } else if (e.getSource() == this.getFullButton) {
                this.textArea.setText(mediator.paper.getPDF());
                mediator.statusBar.setText("Paper's full version loaded.");
            } else if (e.getSource() == this.sendReviewButton) {
                mediator.paper.sendReview(this.textArea.getText());
                mediator.statusBar.setText("Review sent.");
            } else if (e.getSource() == this.updateButton) {
                mediator.paper.update(this.textArea.getText());
                mediator.statusBar.setText("Update sent.");
            } else if (e.getSource() == this.cleanButton) {
                this.textArea.setText("");
            }
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(null, mediator.signature.getName() + " does not have permission to access the method specified.", "Invocation error", JOptionPane.ERROR_MESSAGE);
        }
    }
}
