import rme.security.SecureConfigurator;

import rme.SNService.SecureLookupService;

import arcademis.security.Key;
import arcademis.security.Signature;

public class IntensiveClient {

    public static void main(String a[]) throws Exception {

        if(a.length < 1) {
            System.err.println("Sintaxe: java Client key [host-name]");
            System.exit(1);
        }

        SecureConfigurator c = new SecureConfigurator();
        c.configure();

        PersistentData pd = new PersistentData();
        pd.load(a[0]);
        Key pubKey = pd.getPubKey();
        Signature signature = pd.getSignature();
        String objName = "p1";
        if(a.length > 1)
            objName = a[1];
        Paper paper  = (Paper)SecureLookupService.lookup(objName, signature);
        ((rme.security.SecureStub)paper).setOwner(pd.getPrvKey());
        System.out.println("1000 iteractions...");
        for(int i = 0; i < 1000; i++)
            paper.getAbstract();
        System.out.println("Done");
        for(int i = 0; i < 1000; i++)
            paper.getPDF();
    }

}
