import java.awt.*;
import java.awt.event.*;
import javax.swing.*;



public class GraphClient extends JFrame {

    private JPanel keyCreatorPanel;
    private JPanel mainPanel;

    public GraphClient() {
        // creates the subpanels:
        this.keyCreatorPanel = this.createsKeyCreatorPanel();

        //Create the main panel to contain the two sub panels.
        mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.PAGE_AXIS));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

        //Add the select and display panels to the main panel.
        mainPanel.add(this.keyCreatorPanel);
    }


    /**
     * Creates a panel with elements to define a key. A key is determined
     * by a user name and file name, into which the key should be stored.
     */
    private JPanel createsKeyCreatorPanel() {
        JPanel mainP = new JPanel();
        mainP.setLayout(new BoxLayout(mainP, BoxLayout.PAGE_AXIS));

        JLabel nameL = new JLabel("User name:");
        JTextField nameT = new JTextField(20);
        JPanel auxP1 = new JPanel();
        auxP1.setLayout(new FlowLayout());
        auxP1.add(nameL);
        auxP1.add(nameT);
        mainP.add(auxP1);

        JLabel fileL = new JLabel("File name:");
        JTextField fileT = new JTextField(20);
        JPanel auxP2 = new JPanel();
        auxP2.setLayout(new FlowLayout());
        auxP2.add(fileL);
        auxP2.add(fileT);
        mainP.add(auxP2);

        JButton keyCreatorButton = new JButton("Create");
        mainP.add(keyCreatorButton);

        mainP.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createLoweredBevelBorder(),
                        BorderFactory.createEmptyBorder(5,5,5,5))
        );
        return mainP;
    }


    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        //Create a new instance of GraphClient.
        GraphClient client = new GraphClient();

        //Create and set up the window.
        JFrame graphClientFrame = new JFrame("Graphic Client");
        graphClientFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 
        graphClientFrame.setContentPane(client.mainPanel);

        //Display the window.
        graphClientFrame.pack();
        graphClientFrame.setVisible(true);
    }


    public static void main(String[] args) {
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }

}
