import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import arcademis.security.*;
import rme.SNService.*;

public class ConnectorPanel extends JPanel implements ActionListener {

    private JTextField objectT;
    private JButton connectorButton;
    private JButton loadSigButton;
    private Key pubKey;

    private Mediator mediator;

    /**
     * Creates a panel with elements to define a key. A key is determined
     * by a user name and file name, into which the key should be stored.
     */
    public ConnectorPanel(Mediator mediator) {
        this.mediator = mediator;
        this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

        JLabel hostL = new JLabel("Host name:");
        JPanel auxP1 = new JPanel();
        auxP1.setLayout(new FlowLayout());
        auxP1.add(hostL);
        auxP1.add(mediator.hostT);
        this.add(auxP1);

        JLabel objectL = new JLabel("Object name:");
        this.objectT = new JTextField(20);
        JPanel auxP2 = new JPanel();
        auxP2.setLayout(new FlowLayout());
        auxP2.add(objectL);
        auxP2.add(this.objectT);
        this.add(auxP2);

        this.connectorButton = new JButton("Connect");
        this.connectorButton.addActionListener(this);

        this.loadSigButton = new JButton("Signature");
        this.loadSigButton.addActionListener(this);

        JPanel auxP3 = new JPanel();
        auxP3.setLayout(new FlowLayout());
        auxP3.add(this.connectorButton);
        auxP3.add(this.loadSigButton);
        this.add(auxP3);

        this.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder("Establish connection"),
                        BorderFactory.createEmptyBorder(5,5,5,5))
        );
    }


    public void actionPerformed(ActionEvent e) {
        try {
            if(e.getSource() == this.connectorButton) {
                String hostName = mediator.hostT.getText();
                String objName = this.objectT.getText();
                if(mediator.signature == null) {
                    JOptionPane.showMessageDialog(null, "Choose a signature first.", "Input error", JOptionPane.ERROR_MESSAGE);
                } else if(objName.equals("")) {
                    JOptionPane.showMessageDialog(null, "Define remote object name.", "Input error", JOptionPane.ERROR_MESSAGE);
                } else {
                    if(!hostName.equals(""))
                        objName = hostName + '/' + objName;
System.out.println(objName);
                    mediator.paper  = (Paper)SecureLookupService.lookup(objName, mediator.signature);
                    ((rme.security.SecureStub)mediator.paper).setOwner(mediator.pd.getPrvKey());
                    mediator.statusBar.setText("Connected to " + objName);
                }
            } else if(e.getSource() == this.loadSigButton) {
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showOpenDialog(null);
                if(returnVal == JFileChooser.APPROVE_OPTION) {
                    mediator.pd = new PersistentData();
                    mediator.pd.load(chooser.getSelectedFile().getName());
                    this.pubKey = mediator.pd.getPubKey();
                    mediator.signature = mediator.pd.getSignature();
                    mediator.statusBar.setText("Client signature: " + mediator.signature.toString());
                }
            }
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Invocation error", JOptionPane.ERROR_MESSAGE);
        }
    }
}
