import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import rme.security.SecureConfigurator;


public class App {

    private JPanel mainPanel;
    private ConnectorPanel cp;
    private KeyCreatorPanel kp;
    private InvocationPanel ip;

    public App() {
        //Create the main panel to contain the two sub panels.
        mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.PAGE_AXIS));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

        //Add the select and display panels to the main panel.
        Mediator mediator = new Mediator();
        JPanel auxPanel = new JPanel();
        auxPanel.setLayout(new FlowLayout());
        this.cp = new ConnectorPanel(mediator);
        this.kp = new KeyCreatorPanel(mediator);
        this.ip = new InvocationPanel(mediator);
        auxPanel.add(this.cp);
        auxPanel.add(this.kp);
        mainPanel.add(auxPanel);
        mainPanel.add(this.ip);

        // creating the status bar
        JPanel lp = new JPanel();
        lp.add(mediator.statusBar);
        lp.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder("Current status: "),
                        BorderFactory.createEmptyBorder(5,5,5,5))
        );
        mainPanel.add(lp);
    }


    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        //Create a new instance of GraphClient.
        App client = new App();

        //Create and set up the window.
        JFrame graphClientFrame = new JFrame("Graphic Client");
        graphClientFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 
        graphClientFrame.setContentPane(client.mainPanel);

        //Display the window.
        graphClientFrame.pack();
        graphClientFrame.setVisible(true);
    }


    public static void main(String[] args) {
        try {
            SecureConfigurator c = new SecureConfigurator();
            c.configure();

            javax.swing.SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    createAndShowGUI();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

}
