import rme.security.SecureConfigurator;

import rme.SNService.SecureLookupService;
import rme.SNService.Validator;
import rme.SNService.ConcreteValidator;

import arcademis.Stream;
import arcademis.OrbAccessor;
import arcademis.security.Key;
import arcademis.security.Signature;
import arcademis.security.CryptoSystem;

public class UpClient {
    public static void main(String a[]) throws Exception {
        SecureConfigurator c = new SecureConfigurator();
        c.configure();

        PersistentData pd = new PersistentData();
        pd.load(a[0]);
        Key pubKey = pd.getPubKey();
        Signature signature = pd.getSignature();
        Paper paper  = (Paper)SecureLookupService.lookup("p1", signature);
        ((rme.security.SecureStub)paper).setOwner(pd.getPrvKey());
        System.out.println("Abstract:\n" + paper.getAbstract());

        // proceding key updating
        CryptoSystem cs = OrbAccessor.getCryptoSystem();
        ConcreteValidator cv = new ConcreteValidator(pd.getPrvKey());
        cv.updateNewKey(cs, pd.getPrvKey(), signature);
    }
}
