import rme.SNService.SecureLookupService;
import rme.security.SecureConfigurator;
import rme.security.Reificator;

import arcademis.security.Key;

public class Server {
    public static void main(String a[]) throws Exception {
        SecureConfigurator c = new SecureConfigurator();
        c.configure();

        ConcretePaper paper = new ConcretePaper();

        paper.setAbstract(
            "In this lecture, Mark Burgin defined algorithms, and computational models. Then he characterized the subrecursive algorithms, and finally he introduced the superrecursive algorithms. He tried to explain why these are more powerful than the those computable"
        );

        paper.setPDF(
            "It is well accepted among the computer scientists that the Turing Machine, as well as similar models such as the lambda-calculus, is the ultimate computation model. However, Mark Burgin claimed that the so called super-recursive algorithms, computable by a induced Turing Machine are even more powerful. According to him, it is possible to model events such as input and output of information with a induced Turing Machine, what is not possible using the ordinary model.\n" +
"In my opinion, Burgin's theories are flawed, because, as far as my knowledge of the theme allowed me to say, its model does essentially what a Turing Machine does. I will try to justify. Burgin's induced TM differs from the ordinary model because it output results during computation, and it allow a external agent to change the content of one of its tapes, the input tape. He claims that an induced Turing Machine can solve the halting problem, because, when given a program, if its simulation has not stopped, the machine will output the answer: 'the problem enters in loop'.\n"
        );

        String objName = "";
        if(a.length > 0)
            objName = a[0];
        else
            objName = "p1";
        SecureLookupService.bind(objName, paper);
        paper.activate();
        System.out.println(paper.getClass().getName());
        Reificator.printRemoteMethodList(paper);
        Key key = SecureLookupService.getPublicKey("localhost");
        Reificator.setLookupServicePublicKey(key, paper);
        Reificator.revokeAllPermissions(paper);
        Reificator.grantFreeAccess("Rhyme", paper);
    }
}
