import arcademis.security.*;
import arcademis.Stream;
import arcademis.OrbAccessor;

public class CryptoTest {

    public static void main(String a[]) {
        try {
            test_5();
            System.out.println("-------------------");
            test_4();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printArrayByte(String title, byte[] b) {
        System.out.println(title);
        for(int i = 0; i < b.length; i++)
            System.out.print((int)b[i] + " ");
        System.out.println();
    }


    private static void test_5() throws Exception {
        CryptoSystem cs = OrbAccessor.getCryptoSystem();

        // Generating the first pair of keys:
        cs.generateKeys();
        Key pubKey1 = cs.getPublicKey();
        Key prvKey1 = cs.getPrivateKey();

        // Generating the secon pair of keys:
        cs.reset();
        cs.generateKeys();
        Key pubKey2 = cs.getPublicKey();
        Key prvKey2 = cs.getPrivateKey();

        Certificate cert = new Certificate("Fernando", new java.util.Date(), pubKey1);
        Stream stream1 = new rme.RmeStream();
        Stream stream2 = new rme.RmeStream();

        stream1.write(cert);

        prvKey2.sign(stream1);

        stream2.write(stream1);

        pubKey1.encrypt(stream2);

        prvKey1.decrypt(stream2);

        stream1 = (Stream)stream2.readObject();

        pubKey2.verify(stream1);

        Certificate nCert = (Certificate)stream1.readObject();
        System.out.println("Certificate: " + nCert);
    }


    private static void test_4() throws Exception {
        CryptoSystem cs = OrbAccessor.getCryptoSystem();

        // Generating the first pair of keys:
        cs.generateKeys();
        Key pubKey1 = cs.getPublicKey();
        Key prvKey1 = cs.getPrivateKey();

        // Generating the secon pair of keys:
        cs.reset();
        cs.generateKeys();
        Key pubKey2 = cs.getPublicKey();
        Key prvKey2 = cs.getPrivateKey();

        Certificate cert = new Certificate("Fernando", new java.util.Date(), pubKey1);
        Stream stream1 = new rme.RmeStream();
        Stream stream2 = new rme.RmeStream();
        Stream stream3;

        stream1.write(cert);

System.out.println("stream1: " + stream1.size());
        // enciphering the stream with the second pair of keys:
        pubKey2.encrypt(stream1);
System.out.println("stream1: " + stream1.size());
        // signing the stream with the first pair of keys:
        prvKey1.sign(stream1);

System.out.println("stream1: " + stream1.size());
        // writing everything to another stream, so it can be sent accross a network
        stream2.write(stream1);
System.out.println("stream2: " + stream2.size());
        stream3 = (Stream)stream2.readObject();
System.out.println("stream3: " + stream3.size());

        // verifing signature with the first pair of keys:
        pubKey1.verify(stream3);

System.out.println("stream3: " + stream3.size());
        // deciphering the stream with the second pair of keys:
        prvKey2.decrypt(stream3);

System.out.println("stream3: " + stream3.size());
        Certificate nCert = (Certificate)stream3.readObject();
        System.out.println("Certificate: " + nCert);
    }


    private static void test_3() throws Exception {
        CryptoSystem cs = OrbAccessor.getCryptoSystem();
        cs.generateKeys();
        Key pubKey = cs.getPublicKey();
        Key prvKey = cs.getPrivateKey();
        Certificate cert1 = new Certificate("Rhyme", new java.util.Date(), pubKey);
        Certificate cert2 = new Certificate("Fernando", new java.util.Date(), pubKey);
        rme.RmeStream stream = new rme.RmeStream();
        stream.write(cert1);
        stream.write(cert2);
        prvKey.sign(stream);
        pubKey.verify(stream);
        Certificate nCert1 = (Certificate)stream.readObject();
        Certificate nCert2 = (Certificate)stream.readObject();
        System.out.println("Certificate: " + nCert1);
        System.out.println("Certificate: " + nCert2);
    }


    private static void test_2() throws Exception {
        CryptoSystem cs = OrbAccessor.getCryptoSystem();
        cs.generateKeys();
        Key pubKey = cs.getPublicKey();
        Key prvKey = cs.getPrivateKey();
        Certificate cert1 = new Certificate("Rhyme", new java.util.Date(), pubKey);
        Certificate cert2 = new Certificate("Fernando", new java.util.Date(), pubKey);
        rme.RmeStream stream = new rme.RmeStream();
        stream.write(cert1);
        stream.write(cert2);
        pubKey.encrypt(stream);
        prvKey.decrypt(stream);
        Certificate nCert1 = (Certificate)stream.readObject();
        Certificate nCert2 = (Certificate)stream.readObject();
        System.out.println("Certificate: " + nCert1);
        System.out.println("Certificate: " + nCert2);
    }


/*
    private static void test_1() throws Exception {
        CryptoSystem cs = OrbAccessor.getCryptoSystem();
        cs.generateKeys();
        Key pubKey = cs.getPublicKey();
        Key prvKey = cs.getPrivateKey();
        byte[] plain = "kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk".getBytes();
        System.out.println("Size: " + plain.length);
        byte[] b1 = pubKey.encrypt(plain);
        printArrayByte("Cipher: ", b1);
        byte[] b2 = prvKey.decrypt(b1);
        String s = new String(b2);
        System.out.println("Original message: " + s);
        System.out.println("-------------------");
        rme.RmeStream stream = new rme.RmeStream();
        stream.write(pubKey);
        pubKey = (Key)stream.readObject();
        byte[] b3 = pubKey.encrypt("Hello, Fernando".getBytes());
        printArrayByte("Cipher: ", b3);
        byte[] b4 = prvKey.decrypt(b3);
        s = new String(b4);
        System.out.println("Original message: " + s);
    }
 */
}
