import rme.SNService.SecureLookupService;
import rme.security.SecureConfigurator;
import rme.security.Reificator;

import arcademis.security.Key;

public class Server {
    public static void main(String a[]) throws Exception {
        SecureConfigurator c = new SecureConfigurator();
        c.configure();

        Impl remoteObj = new Impl();
        SecureLookupService.bind("name", remoteObj);
        remoteObj.activate();
        Key key = SecureLookupService.getPublicKey("localhost");
        Reificator.setLookupServicePublicKey(key, remoteObj);
        Reificator.revokeAllPermissions(remoteObj);
        Reificator.grantFreeAccess("Sandy", remoteObj);
    }
}
