import rme.security.SecureConfigurator;
import rme.SNService.SecureLookupService;

import arcademis.security.Key;
import arcademis.security.Signature;

import java.util.StringTokenizer;
import java.io.*;

public class KeyBinder {
    public static void main(String a[]) throws Exception {
        if (a.length == 0) {
            System.err.println("Sintax: java KeyBinder fileName");
            System.exit(1);
        } else {
            SecureConfigurator c = new SecureConfigurator();
            c.configure();

            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(a[0]));
            Key pubKey, prvKey;
            Signature signature;
            try {
                while(true) {
                    signature = (Signature)ois.readObject();
                    System.out.println("Signature: " + signature);
                    pubKey = (Key)ois.readObject();
                    System.out.println("Public key: " + pubKey);
                    prvKey = (Key)ois.readObject();
                    System.out.println("Private key: " + prvKey);
                    SecureLookupService.debut(signature, pubKey);
                }
            } catch (EOFException e) {
                System.out.println("Reached end of file");
                ois.close();
            }
        }
    }
}
/*          BufferedReader catalogue = new BufferedReader(new FileReader(a[0]));
            String line = catalogue.readLine();
            while(line != null) {
                StringTokenizer st = new StringTokenizer(line, "|");
                String name = st.nextToken();
                String key = st.nextToken();
                LongKey longKey = new LongKey(Long.parseLong(key));
                SecureLookupService.debut(name, longKey);
                System.out.println(name + " -> " + longKey);
                line = catalogue.readLine();
            }
 */
