package rme.utilities;

import java.io.*;
import java.util.StringTokenizer;

import rme.*;
import arcademis.security.*;
import arcademis.Stream;
import arcademis.OrbAccessor;

public class PersistentData {
    private Signature signature = null;
    private Key pubKey = null;
    private Key prvKey = null;

    public Key getPrvKey() {
        return this.prvKey;
    }

    public Key getPubKey() {
        return this.pubKey;
    }

    public Signature getSignature() {
        return signature;
    }

    public void generateData(String clientName) throws Exception {
        this.signature = new Signature(clientName);
        CryptoSystem cs = OrbAccessor.getCryptoSystem();
        cs.generateKeys();
        this.pubKey = cs.getPublicKey();
        this.prvKey = cs.getPrivateKey();
    }

    public void store(String pathName)  throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(pathName));
        oos.writeObject(this.signature);
        oos.writeObject(this.pubKey);
        oos.writeObject(this.prvKey);
        oos.close();
    }

    public void storeAtEnd(ObjectOutputStream oos) throws Exception {
        oos.writeObject(this.signature);
        oos.writeObject(this.pubKey);
        oos.writeObject(this.prvKey);
    }

    public void load(String pathName)  throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(pathName));
        this.signature = (Signature)ois.readObject();
        this.pubKey = (Key)ois.readObject();
        this.prvKey = (Key)ois.readObject();
    }

    public String toString() {
        return "Owner: " + this.signature.getName() +
               "\nPublic key: " + this.pubKey.toString() +
               "\nPrivate key: " + this.prvKey.toString();
    }
}

/*
    public void readData(String pathName) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(pathName));
            String line = in.readLine();
            StringTokenizer tk = new StringTokenizer(line, "|");
            String name = tk.nextToken();
            this.signature = new Signature(name);
            String key_value = tk.nextToken();
            this.key = new LongKey(Long.parseLong(key_value));
        } catch (IOException ioe) {
           ioe.printStackTrace();
           System.exit(1);
        }
    }

    public void generateData(String pathName, String clientName) {
        try {
            this.signature = new Signature(clientName);
            this.key = new LongKey();
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(pathName)));
            out.println(clientName + '|' + this.key.getValue());
            out.close();
        } catch (IOException ioe) {
           ioe.printStackTrace();
           System.exit(1);
        }
    }
*/
