package rme.server.atMostOnce;

import arcademis.*;
import arcademis.server.*;
import arcademis.concreteComponents.*;
import arcademis.concreteComponents.atMostOnce.*;
import rme.*;
import rme.server.*;

public class AtMostOnceReqRec extends RequestReceiver implements RmeConstants, Runnable {

	private Channel ch = null;
	private static final int TOLERANCE = 2000; // 2 seconds
	private RequestTable t = null;

	public AtMostOnceReqRec() {
		t = new RequestTable();
	}

	public void open(Channel ch) {
		this.ch = ch;
		Thread t = new Thread(this);
		t.start();
	}

	private void sendWarning(Channel ch, MethodRequest m) throws ArcademisException {
		ArcademisException e = new ArcademisException("Already processed call " + m.getCallID().toString());
		Stream s = OrbAccessor.getStream();
		s.write(e);
		((RmeProtocolChannel)ch).sendReturnMessage(s, m.getCallID());
System.out.println("Warning: message with expired time stamp received.");
	}

	public void run() {
		ch.setConnectionTimeout(TOLERANCE);
		boolean isOperant = true;
		while(isOperant) {
			try {
				byte msgType = ((RmeProtocolChannel)ch).recvMessageHeader();
				switch(msgType) {
					case CALL_MESSAGE: {
						MethodRequest m = ((RmeProtocolChannel)ch).receiveCallMessage();
						if(!t.isTooOld(m)) {
							t.in(m);
							super.skel.setChannel(ch);
							super.skel.dispatch(m);
						} else {
							sendWarning(ch, m);
						}
						break;
					}
					case PING_MESSAGE: {
						((RmeProtocolChannel)ch).sendPingAcknowledge();
						break;
					}
					default:
						throw new ProtocolException("Unknow message type: " + msgType);
				}
			} catch (Exception e) {
				try {
					ch.close();
				} catch(NetworkException ne) {
					e.printStackTrace();
				}
				isOperant = false;
			}
		}
	}

	public void handleEvent(Event e){}
}