package rme.security;

import arcademis.server.Skeleton;

/**
 * This class extends the <CODE>arcademis.server.Skeleton</CODE> class, in
 * order to allow the authentication checking during the processing of
 * remote calls. The basic purpose of this class is to encapsulate a
 * especial dispatcher decorator, which controls the access to the remote
 * methods.
 */
public abstract class SecureSkeleton extends Skeleton {

    private SecureDispatcher sd = null;

    /**
     * Determines the instance of <CODE>SecureDispatcher</CODE> that will be
     * used by the remote object implementation.
     */
    public void setSecureDispatcher(SecureDispatcher sd) {
        this.sd = sd;
        this.sd.setNumberOfMethods(this.getNumberOfMethods());
    }

    /**
     * Grants execution of a single method to a single user.
     */
    public void grantPermission(int method, String name) {
        this.sd.grantPermission(method, name);
    }

    /**
     * Revoke all execution permissions on a single method. This routine is
     * mostly used before invoking the <CODE>grantPermission</CODE> method a
     * number of times in order to define a small set of users that are
     * allowed to execute an specific method.
     */
    public void revokeAllPermissions(int method) {
        this.sd.revokeAllPermissions(method);
    }

    /**
     * Allows a single method to be freely executed by any user.
     */
    public void grantFreeAccess(int method) {
        this.sd.grantFreeAccess(method);
    }

    /**
     * Allows a single user to execute any method.
     */
    public void grantFreeAccess(String name) {
        this.sd.grantFreeAccess(name);
    }

    /**
     * This method may be used to discover the name of all the remote
     * methods stored by this skeleton.
     */
    public abstract String[] getMethodList();

    /**
     * This method reports the number of remote methods implemented by
     * this skeleton
     */
    public abstract int getNumberOfMethods();
}
