package rme.security;

import arcademis.*;
import arcademis.server.*;
import rme.server.*;
import rme.*;

public class SecureServiceHandlerFc implements ServiceHandlerFc, ArcademisConstants, SecureConstants {

	public ServiceHandler createServiceHandler() {
		return null;
	}

	public ServiceHandler createServiceHandler (int objType) {
		switch(objType) {
			case CHANNEL_VERIFIER: return new ChannelVerifier();
                        case REQUEST_RECEIVER: return createRequestReceiver();
			case RESPONSE_RECEIVER: return createResponseReceiver();
			case RESPONSE_SENDER: return createResponseSender();
			case SECURE_REQUEST_SENDER: return createRequestSender();
			default: return null;
		}
	}

	public RequestSender createRequestSender() {
		return new SecureRequestSender();
	}

	public RequestReceiver createRequestReceiver() {
		return new RmeRequestReceiver();
	}

	public ResponseSender createResponseSender() {
		return new RmeResponseSender();
	}

	public ResponseReceiver createResponseReceiver() {
		return new RmeResponseReceiver();
	}
}
