package rme.security;

import arcademis.*;
import rme.extras.*;

public class SecureInvokerFc implements InvokerFc {

	/**
	 * Creates a simple invoker. This is the default method of invoker
	 * instantiation.
	 * @return an object of the <CODE>Invoker</CODE> type.
	 */
	public Invoker createInvoker() {
		return new SecureInvoker();
	}

	/**
	 * Produces a new invoker based on the descriptor that is given to the
	 * factory.
	 * @return an object of the <CODE>Invoker</CODE> type.
	 */
	public Invoker createInvoker (int objType) {
		return new SecureInvoker();
	}

	/**
	 * Empty body.
	 * @param d an object of the <CODE>InvokerDecorator</CODE> type.
	 */
	public void insertDecorator(InvokerDecorator d) {}

	/**
	 * Empty body
	 */
	public void removeDecorators() {}

	/**
	 * Empty body.
	 * @param invoker the new base component.
	 */
	public void setBaseComponent(Invoker invoker) {}
}
