package rme.security;

import arcademis.server.*;
import arcademis.ArcademisException;
import rme.server.RmeDispatcher;
import rme.server.RmeRemoteObject;

public class SecureDispatcherFc implements DispatcherFc {

	private RemoteObject remoteObj = null;

	private boolean log = false;

	private boolean report = false;

	public Dispatcher createDispatcher() {
		Dispatcher d = new RmeDispatcher();
		try {
                        Skeleton skel = remoteObj.getSkeleton();
                        if(! (skel instanceof SecureSkeleton) )
				throw new ArcademisException("Not a secure skeleton: " + skel.getClass().getName());
			SecureSkeleton sSkel = (SecureSkeleton)skel;
			d.setSkeleton(sSkel);
			SecureDispatcher sd = new SecureDispatcher(d);
			sd.setNumberOfMethods(sSkel.getNumberOfMethods());
			d = sd;
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
		if(log)
			d = new rme.extras.server.LogDispatcher(d);
		if(report)
			d = new rme.extras.server.ReportLoadDispatcher(d);
		return d;
	}

	public Dispatcher createDispatcher(int objType) {
		Dispatcher d = new RmeDispatcher();
		try {
                        Skeleton skel = remoteObj.getSkeleton();
                        if(! (skel instanceof SecureSkeleton) )
				throw new ArcademisException("Not a secure skeleton: " + skel.getClass().getName());
			SecureSkeleton sSkel = (SecureSkeleton)skel;
			d.setSkeleton(sSkel);
			SecureDispatcher sd = new SecureDispatcher(d);
			sd.setNumberOfMethods(sSkel.getNumberOfMethods());
			d = sd;
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
		if(log)
			d = new rme.extras.server.LogDispatcher(d);
		if(report)
			d = new rme.extras.server.ReportLoadDispatcher(d);
		return d;
	}

	public void setRemoteObject(RemoteObject remoteObj) {
		this.remoteObj = remoteObj;
	}
}
