package rme.security;

public interface SecureConstants {

    /**
     * After one of the peers receve a call message, it must verify if this
     * message was actually sent by the entity that claims to have sent it.
     * The <CODE>RQuestionMessage</CODE> is used with this purpose.
     */
    public final byte R_QUESTION_MESSAGE = (byte)0x55;
    public final byte R_REPLAY_MESSAGE = (byte)0x56;

    /**
     * The constant SECURE_CALL_MESSAGE indicates a message that contains a
     * method request, in the RMEP protocol.
     */
    public final byte SECURE_CALL_MESSAGE = (byte)0x57;

    /**
     */
    public final int SECURE_REQUEST_SENDER = 6;

}
