package rme.security;

import arcademis.*;
import arcademis.server.*;
import arcademis.security.*;
import rme.*;
import rme.rmep.*;
import rme.server.*;

public final class SecureConfigurator implements Configurator {
	public void configure() throws ReconfigurationException {
		if(ORB.isOpenForReconfiguration()) {

			// Define the Acceptors
			AcceptorFc acFc = new RmeAcceptorFc();
			ORB.setAcceptorFactory(acFc);

			// define the activator factory
			ActivatorFc atFc = new RmeActivatorFc();
			ORB.setActivatorFactory(atFc);

			// Define the channel factory
			ChannelFc cnFc = new RmeChannelFc();
			ORB.setChannelFactory(cnFc);

			// Define the connection server factory
			ConnectionServerFc csFc = new RmeConServerFc();
			ORB.setConnectionServerFactory(csFc);

			// Define the Connectors
			ConnectorFc coFc = new RmeConnectorFc();
			ORB.setConnectorFactory(coFc);

			// define the crypto system factory
//			CryptoSystemFc crFc = new XorKeyFc();
			CryptoSystemFc crFc = new RsaKeyFc();
			ORB.setCryptoSystemFactory(crFc);

			// define the dispatcher factory
			DispatcherFc dpFc = new SecureDispatcherFc();
			ORB.setDispatcherFactory(dpFc);

			// Define a fabrica de enderecos remotos
			EpidFc epFc = new RmeEpidFc();
			ORB.setEpidFactory(epFc);

			// Define a fabrica de identificadores remotos
			IdentifierFc idFc = new RmeIdentifierFc();
			ORB.setIdentifierFactory(idFc);

			// define the invoker factory
			InvokerFc ivFc = new SecureInvokerFc();
			ORB.setInvokerFactory(ivFc);

			// Define the message factory
			MessageFc msFc = new RmeMessageFc();
			ORB.setMessageFactory(msFc);

			// Define the protocol factory
			ProtocolFc ptFc = new RmeProtocolFc();
			ORB.setProtocolFactory(ptFc);

			// Define a fabrica de referencias remotas
			RemoteRefFc rrFc = new RmeRemoteRefFc();
			ORB.setRemoteRefFactory(rrFc);

			// Define the service handler factory
			ServiceHandlerFc shFc = new SecureServiceHandlerFc();
			ORB.setServiceHandlerFactory(shFc);

			// Define the stream factory
			StreamFc sfFc = new RmeStreamFc();
			ORB.setStreamFactory(sfFc);

			ORB.closeForReconfiguration();
		}

	}
}
