package rme.security;

import arcademis.server.Dispatcher;
import arcademis.server.DispatcherDecorator;
import arcademis.ArcademisException;
import arcademis.security.Key;
import rme.server.RmeRemoteObject;

/**
 * This class exposes to the user some parts of the middleware that normally
 * are encapsulated, such as the chain of dispatcher, for example.
 */
public class Reificator {

    public static Dispatcher getSpecificDispatcher(String classType, Dispatcher dispatcher) {
        if(dispatcher.getClass().getName().equals(classType))
            return dispatcher;
        else if(dispatcher instanceof DispatcherDecorator) {
            DispatcherDecorator dd = (DispatcherDecorator)dispatcher;
            return getSpecificDispatcher(classType, dd.getDecoratedDispatcher());
        } else return null;
    }

    public static void printRemoteMethodList(RmeRemoteObject o) throws ArcademisException {
        Dispatcher d = o.getDispatcher();
        SecureSkeleton ss = (SecureSkeleton)d.getSkeleton();
        String[] ml = ss.getMethodList();
        for(int i = 0; i < ml.length; i++)
            System.out.println(i + " -> " + ml[i]);
    }


    /**
     * Binds the public key used by the discovery agency to this dispatcher.
     * This key will be used to validate the certificates issued by the
     * discovery agency.
     * @param key the public key of the discovery agency.
     */
    public static void setLookupServicePublicKey(Key key, RmeRemoteObject o) {
        Dispatcher d = o.getDispatcher();
        SecureDispatcher sd = (SecureDispatcher)Reificator.getSpecificDispatcher("rme.security.SecureDispatcher", d);
        sd.setLookupServicePublicKey(key);
    }


    /**
     * Grants execution of a single method to a single user.
     */
    public static void grantPermission(int method, String name, RmeRemoteObject o) {
        Dispatcher d = o.getDispatcher();
        SecureDispatcher sd = (SecureDispatcher)Reificator.getSpecificDispatcher("rme.security.SecureDispatcher", d);
        sd.grantPermission(method, name);
    }


    /**
     * Revoke all execution permissions on a single method. This routine is
     * mostly used before invoking the <CODE>grantPermission</CODE> method a
     * number of times in order to define a small set of users that are
     * allowed to execute an specific method.
     */
    public static void revokeAllPermissions(int method, RmeRemoteObject o) {
        Dispatcher d = o.getDispatcher();
        SecureDispatcher sd = (SecureDispatcher)Reificator.getSpecificDispatcher("rme.security.SecureDispatcher", d);
        sd.revokeAllPermissions(method);
    }


    public static void revokeAllPermissions(RmeRemoteObject o) {
        Dispatcher d = o.getDispatcher();
        SecureDispatcher sd = (SecureDispatcher)Reificator.getSpecificDispatcher("rme.security.SecureDispatcher", d);
        sd.revokeAllPermissions();
    }


    /**
     * Allows a single method to be freely executed by any user.
     */
    public static void grantFreeAccess(int method, RmeRemoteObject o) {
        Dispatcher d = o.getDispatcher();
        SecureDispatcher sd = (SecureDispatcher)Reificator.getSpecificDispatcher("rme.security.SecureDispatcher", d);
        sd.grantFreeAccess(method);
    }

    /**
     * Allows a single user to execute any method.
     */
    public static void grantFreeAccess(String name, RmeRemoteObject o) {
        Dispatcher d = o.getDispatcher();
        SecureDispatcher sd = (SecureDispatcher)Reificator.getSpecificDispatcher("rme.security.SecureDispatcher", d);
        sd.grantFreeAccess(name);
    }

    /**
     * Grants free access to every method.
     */
    public static void grantFreeAccess(RmeRemoteObject o) {
        Dispatcher d = o.getDispatcher();
        SecureDispatcher sd = (SecureDispatcher)Reificator.getSpecificDispatcher("rme.security.SecureDispatcher", d);
        sd.grantFreeAccess();
    }
}
