package rme.rmep;

import arcademis.*;
import arcademis.security.ArcademisCryptoException;
import rme.RmeConstants;

/**
 */
public class RReplayMsg implements Message {

	private long randValue = 0L;

        /**
         * Every secure message carries a random number. This number helps to
         * avoid replay attacks. Upon receiving a secure message, the peer can
         * write a confirmation to the sender, with the encrypted random
         * number. If the sender ever responds, it is because it actually
         * wants to contact the receiver.
         * @param randValue the number that will be used to mark this message.
         */
        public void setRandomValidator(long randValue) {
                this.randValue = randValue;
        }

        /**
         * Returns the random number used to validate this message.
         * @return a <CODE>long</CODE> value.
         */
        public long getRandomValidator() {
                return this.randValue;
        }

	/**
	 * Fills the stream b with the byte sequence that describes this object.
	 * @throws MarshalException if it is not possible to serialize this object.
	 * @param the stream used in the serialization process.
	 */
	public void marshal(Stream b) throws MarshalException {
		b.write(this.randValue);
	}

	/**
	 * Fills the content of this object with information retrived from a
	 * stream.
	 * @param the stream used in the serialization process.
	 */
	public void unmarshal(Stream b) throws MarshalException {
		this.randValue = b.readLong();
	}

	/**
	 * @param the request receiver that received this message.
	 */
	public void execute(ProtocolHandler s) {
	}
}
