package rme.rmec;

import java.io.PrintWriter;

/*
 * This interface defines methods for generating stubs and skeletons.
 * The stub and the skeleton must be generated from a remote object, that is,
 * an object that implements one or more remote interfaces. A remote interface
 * is one that extends the <CODE>arcademis.remote</CODE> interface.
 * For each method declared in the remote interface, code will be generated in
 * the stub, and in the skeleton. Notice that a remote object can implement
 * more that one remote interface.
 * The following list of methods is defined:
 * <UL>
 * <LI> public void writeStubOutput(PrintWriter pw);
 * <LI> public void writeSkelOutput(PrintWriter pw);
 * <LI> public String getStubName();
 * <LI> public String getSkelName();
 * <LI> public String getPackageName();
 * <LI> public String getClassShortName();
 * </UL>
 */
public interface StubSkeletonGenerator {

    /**
     * This method generates the stub code.
     * @param pw the output will be written in the given file.
     */
    public void writeStubOutput(PrintWriter pw);

    /**
     * This method generates the stub code.
     * @param pw the output will be written in the given file.
     */
    public void writeSkelOutput(PrintWriter pw);

    /**
     * This method outputs the name of the stub class. The stub will be
     * generated as a class.
     * @return an object of the <CODE>String</CODE> type.
     */
    public String getStubName();

    /**
     * This method outputs the name of the skeleton class. The skeleton will be
     * generated as a class.
     * @return an object of the <CODE>String</CODE> type.
     */
    public String getSkelName();

    /**
     * This method yields the name of the target class. The stub and skeleton
     * codes will reflect the remote interfaces implemented by the target class.
     * @return an object of the <CODE>String</CODE> type.
     */
    public String getClassShortName();

    /**
     * This method informs the name of the package that contains the target
     * class. The target class must implement one or more remote interfaces.
     * @return an object of the <CODE>String</CODE> type.
     */
    public String getPackageName();
}
