// Ninja Codegen, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * This code was adapted from the NinjaRMI compiler, implemented by Matt Welsh.
 * The author of RME and Arcademis is Fernando Magno Quintao Pereira. The
 * copyright statement of the original code is as follows:
 *
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

package rme.rmec;

import java.lang.reflect.*;

/**
 * A convenience class for dealing with parameters of methods.
 */
public class ParameterDecomposer {
  TypeDecomposer td;
  String name;

  /**
   * Create a new ParameterDecomposer for the given class and a
   * name for the parameter.
   */
  public ParameterDecomposer(Class param, String thename) {
    td = new TypeDecomposer(param);
    name = thename;
  }

  /**
   * Return the type of the parameter.
   */
  public Class getType() {
    return td.getType();
  }

  /**
   * Return the name of the parameter's type, in a Java-source-compatible
   * form.
   */
  public String getTypeName() {
    return td.getName();
  }

  /**
   * Return the name of the parameter.
   */
  public String getName() {
    return name;
  }

  /**
   * Return the type name followed by the parameter name, as a string.
   */
  public String toString() {
    return td.toString() + " " + name;
  }

}
