package rme.naming;

import rme.*;
import arcademis.*;
import arcademis.server.*;
import arcademis.concreteComponents.*;

public class RmeServiceDirectory_Impl_Stub extends MultiServerStub implements ClientNamingService, ServerNamingService {

    public Remote lookup(String name) throws ArcademisException, NotBoundException {
    	Remote resp = null;
		try {
			Stream args = OrbAccessor.getStream();
			args.write(name);
			int op = 1;
			Stream future = invoke(args, op, '?', 0);
			if(future.isException()) {
				Exception e = (Exception)future.readObject();
				throw e;
			}
			resp = (Remote)future.readObject();
		} catch (ArcademisException e) {
			throw e;
		} catch (NotBoundException e) {
			throw e;
		} catch (Exception e) {
			throw new arcademis.UnspecifiedException(e.toString());
		}
		return resp;
    }

	public void bind(String name, Stub obj) throws ArcademisException, AlreadyBoundException {
    	Object resp = null;
		try {
			Stream args = OrbAccessor.getStream();
			args.write(name);
			args.write(obj);
			int op = 2;
			Stream future = invoke(args, op, '?', 0);
			if(future.isException()) {
				Exception e = (Exception)future.readObject();
				throw e;
			}
			resp = future.readObject();
		} catch (ArcademisException e) {
			throw e;
		} catch (AlreadyBoundException e) {
			throw e;
		} catch (Exception e) {
			throw new arcademis.UnspecifiedException(e.toString());
		}
    }

	public void unbind(String name) throws ArcademisException, NotBoundException {
    	Object resp = null;
		try {
			Stream args = OrbAccessor.getStream();
			args.write(name);
			int op = 3;
			Stream future = invoke(args, op, '?', 0);
			if(future.isException()) {
				Exception e = (Exception)future.readObject();
				throw e;
			}
			resp = future.readObject();
		} catch (NotBoundException e) {
			throw e;
		} catch (ArcademisException e) {
			throw e;
		} catch (Exception e) {
			throw new arcademis.UnspecifiedException(e.toString());
		}
    }

	public void rebind(String name, Stub obj) throws ArcademisException {
    	Object resp = null;
		try {
			Stream args = OrbAccessor.getStream();
			args.write(name);
			args.write(obj);
			int op = 4;
			Stream future = invoke(args, op, '?', 0);
			if(future.isException()) {
				Exception e = (Exception)future.readObject();
				throw e;
			}
			resp = future.readObject();
		} catch (ArcademisException e) {
			throw e;
		} catch (Exception e) {
			throw new arcademis.UnspecifiedException(e.toString());
		}
    }

	public String[] list() throws ArcademisException {
    	String[] resp = null;
		try {
			Stream args = OrbAccessor.getStream();
			int op = 5;
			Stream future = invoke(args, op, '?', 0);
			if(future.isException()) {
				Exception e = (Exception)future.readObject();
				throw e;
			}
			resp = (String[])future.readObject();
		} catch (ArcademisException e) {
			throw e;
		} catch (Exception e) {
			throw new arcademis.UnspecifiedException(e.toString());
		}
		return resp;
    }
}