package rme.SNService;

import arcademis.Stream;
import arcademis.Remote;
import arcademis.ArcademisException;

public interface Validator extends Remote {

    /**
     * This method is used by the discovery agency so it can assure that the
     * caller client is who it says it is. Every time a client request the
     * update of a key, it sends attached to the request a random integer
     * number. The discovery agency encrypts this number with the client's
     * public key. The validator sends the ciphered data to the client, and
     * waits for an answer. If the client is able to decipher the number,
     * and to send that number minus one to the validator, the validator
     * assumes that the client is, indeed, the owner of the public key
     * that is being updated.
     * @param tokens two random numbers used in the validation protocol.
     * @return a encrypted stream. This stream contains the token send by
     * the discovery agency decreased by one unit.
     */
    public Stream check(Stream tokens) throws ArcademisException;

}
