package rme.SNService;

import rme.*;
import rme.server.*;
import java.util.*;
import arcademis.*;
import arcademis.server.*;
import arcademis.concreteComponents.*;

import rme.security.SecureStub;
import arcademis.security.Key;
import arcademis.security.Signature;
import arcademis.security.Certificate;
import arcademis.security.Key;
import arcademis.security.CryptoSystem;
import arcademis.security.ArcademisCryptoException;

/**
 * This class is part of the rme project.
 * Author: Fernando Magno Quintao Pereira.
 * ---------------------------------------
 * This class is a implementation of a name server. The name server
 * stores the location of distributed objects and informs it to requesting
 * clients
 */
public class SecureServiceDirectory_Impl extends RmeRemoteObject implements ClientNamingService, ServerNamingService, RmeConstants {

	private static CryptoSystem cryptoSystem = null;

	private static Hashtable directory = null;

	private static KeyManager keyCatalogue = null;

        private static Certificate certificate = null;

	public SecureServiceDirectory_Impl() {

                System.err.println("Initializing discovery agency...");

		// generation of public and private keys
		cryptoSystem = OrbAccessor.getCryptoSystem();
		cryptoSystem.generateKeys();

		// creation of the epid
		HostPortEpid epid = (HostPortEpid)OrbAccessor.getEpid();
		epid.setHostName("localhost");
		epid.setPortNumber(REGISTRY_PORT);

		// creation of the object id
		RmeIdentifierFc idFc = (RmeIdentifierFc)ORB.getIdentifierFactory();
		HostTimeCountId nameServerIdentifier = (HostTimeCountId)idFc.createIdentifier((short)0);

		// creation of the remote reference
		RemoteReference rRef = OrbAccessor.getRemoteRef(epid, nameServerIdentifier);

		super.remoteRef = rRef;
		directory = new Hashtable();
                // will wake up every day to remove old keys.
		keyCatalogue = new KeyManager();

		// creation of the discovery agency's certificate
		certificate = new Certificate();
		certificate.setName("Discovery Agency");
                System.err.println("Discovery agency running.");
	}


    public Key getPublicKey() {
        return cryptoSystem.getPublicKey();
    }


    public SecureStub lookup(String name, Signature signature) throws NotBoundException {
    	SecureStub stb = (SecureStub)directory.get(name);
    	if(stb == null)
    		throw new NotBoundException("The name " + name + " is not currently bound");
    	else if(!isAlive(stb)) {
    		directory.remove(name);
    		throw new NotBoundException("The name " + name + " is not currently bound");
    	}
	String clientName = signature.getName();
	Key clientPublicKey = (Key)keyCatalogue.get(signature);
        if(clientPublicKey == null) {
            System.out.println(signature.getName() + " has not a registered public key");
            throw new NotBoundException(signature.getName() + " has not a registered public key");
        } else {
            System.out.println(signature.getName() + " looking for " + name);
        }
	Date timeStamp = new Date();
	Certificate clientCertificate = new Certificate(clientName, timeStamp, clientPublicKey);
        Stream stream1 = OrbAccessor.getStream();
        Stream stream2 = OrbAccessor.getStream();
        Key prvClKey = this.cryptoSystem.getPrivateKey();
        try {
            stream1.write(clientCertificate);
            prvClKey.sign(stream1);
            stream2.write(stream1);
            clientPublicKey.encrypt(stream2);
        } catch (Exception ae) {
            ae.printStackTrace();
        }
	stb.setCertificate(stream2);
    	return stb;
    }

    public SecureStub lookup(String name) throws NotBoundException {
    	SecureStub stb = (SecureStub)directory.get(name);
    	if(stb == null)
    		throw new NotBoundException("The name " + name + " is not currently bound");
    	else if(!isAlive(stb)) {
    		directory.remove(name);
    		throw new NotBoundException("The name " + name + " is not currently bound");
    	}
    	return stb;
    }

	public void bind(String name, Stub obj) throws AlreadyBoundException {
		Stub stb = (Stub)directory.get(name);
		if(stb != null) {
			if(!isAlive(stb))
				directory.remove(name);
			else
				throw new AlreadyBoundException("The name " + name + " is already bound");
		}
		directory.put(name, obj);
	}

	public void unbind(String name) throws NotBoundException {
		Stub stb = (Stub)directory.remove(name);
		if(stb == null)
			throw new NotBoundException("The name " + name + " is not currently bound");
		else
			directory.remove(name);
	}

	public void rebind(String name, Stub obj) {
		directory.put(name, obj);
	}

	public String[] list() {
		Vector v = new Vector();

		Enumeration enum = directory.keys();

		if(!enum.hasMoreElements())
			return null;

		while(enum.hasMoreElements())
			v.addElement(enum.nextElement());

		String list[] = new String[v.size()];

		for(int c = 0; c < v.size(); c++)
			list[c] = (String)(v.elementAt(c));

		return list;
	}

	public Stub getStub() {
		SecureServiceDirectory_Impl_Stub stub = new SecureServiceDirectory_Impl_Stub();
		stub.attach(super.remoteRef);
		return stub;
	}

        public void update(Validator validator, Stream cipher, Signature signature, int randomA, Key publicKey) {
            try {
                Key clientPublicKey = (Key)keyCatalogue.get(signature);
                clientPublicKey.verify(cipher);
                String verifiedName = (String)cipher.readObject();
                if(!verifiedName.equals(signature.getName()))
                    throw new ArcademisCryptoException(signature.getName() + " is probably a forged name");
                Stream tokens = OrbAccessor.getStream();
                tokens.write(randomA);
                int randomB = (int)(Math.random() * Integer.MAX_VALUE);
                tokens.write(randomB);
                clientPublicKey.encrypt(tokens);
                Stream ans = validator.check(tokens);
                clientPublicKey.verify(ans);
                int tkAns = ans.readInt();
                if(tkAns == randomB - 1) {
                    keyCatalogue.put(signature, publicKey);
                    System.out.println("Discovery Agency - new key update successfully: " + signature.getName());
                }
            } catch(ArcademisException e) {
                e.printStackTrace();
            }
        }

	public void debut(Signature signature, Key key) {
try {
		keyCatalogue.put(signature, key);
                keyCatalogue.printKeyCatalogue();
} catch (Exception e) {
e.printStackTrace();
}
	}


        public long getRemoteTime() {
            Date currentTime = new Date();
            return currentTime.getTime();
        }


	/**
	 * Verifies if the remote object referenced by stb is receiving calls.
	 */
	private boolean isAlive(Stub stb) {
		try {
			ChannelVerifier cv = (ChannelVerifier)OrbAccessor.getServiceHandler(RmeServiceHandlerFc.CHANNEL_VERIFIER);
			cv.setProtocol(OrbAccessor.getProtocol());
			Connector c = OrbAccessor.getConnector();
			MultiReference mr = stb.getRemoteReferences();
			Epid epid = mr.nextReference().getEpid();
			c.connect(cv, epid);
			return cv.isOpen();
		} catch (NetworkException e) {
			return false;
		}
	}
}
