package rme.SNService;

import arcademis.Stream;
import arcademis.ORB;
import arcademis.OrbAccessor;
import arcademis.server.ActivatorFc;
import arcademis.security.Key;
import rme.server.RmeRemoteObject;
import arcademis.ArcademisException;
import arcademis.security.Signature;
import arcademis.security.CryptoSystem;

public class ConcreteValidator extends RmeRemoteObject implements Validator {

    private Key prvKey = null;

    private int token = 0;

    public ConcreteValidator(Key prvKey) {
        this.token = (int) (Math.random() * Integer.MAX_VALUE);
        this.prvKey = prvKey;
    }

    public int getToken() {
        return this.token;
    }

    /**
     * This method is used by the discovery agency so it can assure that the
     * caller client is who it says it is. Every time a client request the
     * update of a key, it sends attached to the request a random integer
     * number. The discovery agency encrypts this number with the client's
     * public key. The validator sends the ciphered data to the client, and
     * waits for an answer. If the client is able to decipher the number,
     * and to send that number minus one to the validator, the validator
     * assumes that the client is, indeed, the owner of the public key
     * that is being updated.
     * @param tokens two random numbers used in the validation protocol.
     * @return a encrypted stream. This stream contains the token send by
     * the discovery agency decreased by one unit.
     */
    public Stream check(Stream tokens) {
        Stream stream = OrbAccessor.getStream();
        try {
            this.prvKey.decrypt(tokens);
            int randomA = tokens.readInt();
            int randomB = tokens.readInt();
            if(randomA != this.token)
                randomB = 1;
            stream.write(randomB - 1);
            this.prvKey.sign(stream);
        } catch (ArcademisException me) {
            me.printStackTrace();
        }
        return stream;
    }

    /**
     * This method generates a new key and updates its value in the discovery
     * agency.
     */
    public void updateNewKey(CryptoSystem cs, Key oldPrvKey, Signature signature) {
        try {
            ActivatorFc fc = ORB.getActivatorFactory();
            ORB.setActivatorFactory(new OneCallActivatorFc());
            cs.generateKeys();
            Key newPubKey = cs.getPublicKey();
            ConcreteValidator cv = new ConcreteValidator(oldPrvKey);
            Stream cipher = OrbAccessor.getStream();
            cipher.write(signature.getName());
            oldPrvKey.sign(cipher);
            cv.activate();
            SecureLookupService.update(cv, cipher, signature, cv.getToken(), newPubKey);
            ORB.setActivatorFactory(fc);
        } catch (Exception ae) {
            ae.printStackTrace();
        }
    }

}
