package rme.SNService;

import arcademis.*;
import arcademis.server.*;
import arcademis.security.Key;
import arcademis.security.Signature;

public interface ClientNamingService extends Remote {
    /**
     * This method search the name server for a specific service provider. If
     * such provider is registered in the discovery agency, its stub will be
     * returned to the client.
     * @param name the name of the service requester to whom the client wants
     * to gain access.
     * @return the stub of the service provider, or null if the service
     * provider is not registered in the discovery agency.
     * @throws NotBoundException if the service provider is not registered in
     * the discovery agency.
     */
    public rme.security.SecureStub lookup(String name) throws NotBoundException, ArcademisException;

    /**
     * This method allows a client application to look for a particular
     * service provider registered in the discovery agency. In this case the
     * client must provide its signature, so the discovery agency can
     * generate a certificate for it.
     * @param name the name of the service requester to whom the client wants
     * to gain access.
     * @return the stub of the service provider, or null if the service
     * provider is not registered in the discovery agency.
     * @throws NotBoundException if the service provider is not registered in
     * the discovery agency.
     */
    public rme.security.SecureStub lookup(String name, Signature signature) throws NotBoundException, ArcademisException;

    /**
     * Returns a list of all the service requesters registered in the
     * discovery agency.
     * @return an array of strings containing all, and only all, the service
     * requesters registered in the discovery agency.
     */
    public String[] list() throws ArcademisException;

    /**
     * This operation allows the client application to register its public key
     * in the discovery agency. The discovery agency needs the public keys of
     * clients in order to issue them certificates.
     * @param signature the signature must contain the name that must be bound
     * to the public key in the discovery agency database.
     * @param publicKey the public key of the client.
     */
    public void debut(Signature signature, Key publicKey) throws ArcademisException;

    /**
     * Returns the current time in the discovery agency. This method is useful in order
     * to test the validity of certificates.
     */
    public long getRemoteTime() throws ArcademisException;

    /**
     * This method allows a client to update its public key in the discovery
     * agency. The updating protocol is more complex than the other operations
     * because it must ensure that the entity trying to update the key is
     * indeed the client that first created that key.
     * @param validator the object that will be used to perform the validation
     * protocol.
     * @param signature the signature must contain the name that must be bound
     * to the public key in the discovery agency database.
     * @param publicKey the new public key the client is trying to register.
     * @param random this integer number is used as a validator, so the
     * discovery agency can check that the client is indeed the owner of the
     * public key.
     */
    public void update(Validator validator, Stream cipher, Signature signature, int random, Key publicKey) throws ArcademisException;
}
