package rme;

import arcademis.*;
import arcademis.server.*;
import rme.rmep.*;
import rme.server.*;

public final class RmeConfigurator implements Configurator {
	public void configure() throws ReconfigurationException {
		if(ORB.isOpenForReconfiguration()) {

			// Define the Acceptors
			AcceptorFc acFc = new RmeAcceptorFc();
			ORB.setAcceptorFactory(acFc);

			// define the activator factory
			ActivatorFc atFc = new RmeActivatorFc();
			ORB.setActivatorFactory(atFc);

			// Define the channel factory
			ChannelFc cnFc = new RmeChannelFc();
			ORB.setChannelFactory(cnFc);

			// Define the Connectors
			ConnectorFc coFc = new RmeConnectorFc();
			ORB.setConnectorFactory(coFc);

			// Define the connection server factory
			ConnectionServerFc csFc = new RmeConServerFc();
			ORB.setConnectionServerFactory(csFc);

			// define the dispatcher factory
			DispatcherFc dpFc = new RmeDispatcherFc();
			ORB.setDispatcherFactory(dpFc);

			// Define a fabrica de enderecos remotos
			EpidFc epFc = new RmeEpidFc();
			ORB.setEpidFactory(epFc);

			// Define a fabrica de identificadores remotos
			IdentifierFc idFc = new RmeIdentifierFc();
			ORB.setIdentifierFactory(idFc);

			// define the invoker factory
			InvokerFc ivFc = new RmeInvokerFc();
			ORB.setInvokerFactory(ivFc);

			// Define the message factory
			MessageFc msFc = new RmeMessageFc();
			ORB.setMessageFactory(msFc);

			// Define the protocol factory
			ProtocolFc ptFc = new RmeProtocolFc();
			ORB.setProtocolFactory(ptFc);

			// Define a fabrica de referencias remotas
			RemoteRefFc rrFc = new RmeRemoteRefFc();
			ORB.setRemoteRefFactory(rrFc);

			// Define the service handler factory
			ServiceHandlerFc shFc = new RmeServiceHandlerFc();
			ORB.setServiceHandlerFactory(shFc);

			// Define the stream factory
			StreamFc sfFc = new RmeStreamFc();
			ORB.setStreamFactory(sfFc);

			ORB.closeForReconfiguration();
		}

	}
}
