package arcademis.server;

/**
 * This interface determines the dispatcher factory. Whenever necessary to
 * modify the dispatching strategy used by the middleware
 * platform, it is sufficient to change the factory's implementation so it will
 * return the proper chain of dispatchers.
 */
public interface DispatcherFc {

    /**
     * This method allows to determine the implementation of the remote object that
     * will be bound to each dispatcher. The dispatcher needs a reference to the
     * remote object, because this element can be used as a skeleton factory.
     * Every time it is necessary to create a dispatcher, a new instance of
     * skeleton must be created and bound to that dispatcher.
     */
    public void setRemoteObject(RemoteObject remoteObj);

    /**
     * Creates a default dispatcher
     * @return an object of the <CODE>Dispatcher</CODE> type.
     */
    public Dispatcher createDispatcher ();

    /**
     * Creates a specific dispatcher
     * @param objType defines the type of the identifier that will be created.
     * @return an object of the <CODE>Dispatcher</CODE> type.
     */
    public Dispatcher createDispatcher (int objType);
}
