package arcademis.server;

import arcademis.*;

/**
 * This exception denotes errors that happened during the remote object
 * initialization.
 */
public class ActivationException extends ArcademisException {
	/**
	 * Empty constructor. Puts a standard message into the error stack.
	 */
	public ActivationException() {
		super("Error during remote objetc activation");
	}

	/**
	 * This constructor inserts the given message into the error queue.
	 * @param msg the message to be inserted into the queue.
	 */
	public ActivationException(String msg) {
		super(msg);
	}
}
