package arcademis.security;

public class XorCryptoSystem implements CryptoSystem {

    private XorKey key;

    public XorCryptoSystem () {}
    /**
     * This method generates a new pair of keys: a private, and a public one.
     * It should keep the invariant condition that, successive invocations of
     * the method <CODE>getPublicKey</CODE> intertwined with an call to the
     * <CODE>generateKeys</CODE> method will return different keys. The same
     * holds for the <CODE>getPrivateKey</CODE> method.
     */
    public void generateKeys() {
        key = new XorKey();
    }

    /**
     * Return the public key stored on the <CODE>CryptoSystem</CODE> object.
     * If a different key is desired, the method <CODE>generateKeys</CODE>
     * must be invoked. There are different types of public key cryptographic
     * system. In the Xor model, the public key is the factor of two large
     * prime numbers: k = p*q.
     * @return a serializable object of the <CODE>Key</CODE> type.
     */
    public Key getPublicKey() {
        return this.key;
    }
	    

    /**
     * Return the private key stored on the <CODE>CryptoSystem</CODE> object.
     * If a different key is desired, the method <CODE>generateKeys</CODE>
     * must be invoked.
     * @return a serializable object of the <CODE>Key</CODE> type.
     */
    public Key getPrivateKey() {
        return this.key;
    }	
	


    /**
     * This method erase the public and private keys stored in the
     * <CODE>CryptoSystem</CODE> object. It prevents the keys of being stolen
     * after they have been created.
     */
    public void reset() {
	key = null;
   }
}
