package arcademis.security;

import gnu.crypto.sig.rsa.RSA;
import gnu.crypto.key.rsa.RSAKeyPairGenerator;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;

public class RSACryptoSystem implements CryptoSystem {

	private RSAKeyPairGenerator kpg;
	private HashMap map;
	private KeyPair kp;
	
    public RSACryptoSystem () {}
    /**
     * This method generates a new pair of keys: a private, and a public one.
     * It should keep the invariant condition that, successive invocations of
     * the method <CODE>getPublicKey</CODE> intertwined with an call to the
     * <CODE>generateKeys</CODE> method will return different keys. The same
     * holds for the <CODE>getPrivateKey</CODE> method.
     */
    public void generateKeys() {
	    kpg = new RSAKeyPairGenerator();
	    map = new HashMap();
	    map.put(RSAKeyPairGenerator.MODULUS_LENGTH, new Integer(1024));
	    kpg.setup(map);
	    
	    kp = kpg.generate();
    }

    /**
     * Return the public key stored on the <CODE>CryptoSystem</CODE> object.
     * If a different key is desired, the method <CODE>generateKeys</CODE>
     * must be invoked. There are different types of public key cryptographic
     * system. In the RSA model, the public key is the factor of two large
     * prime numbers: k = p*q.
     * @return a serializable object of the <CODE>Key</CODE> type.
     */
    public Key getPublicKey() {
	//BigInteger n1 = ((RSAPublicKey) kp.getPublic()).getModulus();
	//BigInteger e =  ((RSAPublicKey) kp.getPublic()).getPublicExponent();
	//Key pubKey = new Key(n1, e);
	//return pubKey;
	
	 return new RsaKey((RSAPublicKey) (kp.getPublic()));
    }
	    

    /**
     * Return the private key stored on the <CODE>CryptoSystem</CODE> object.
     * If a different key is desired, the method <CODE>generateKeys</CODE>
     * must be invoked.
     * @return a serializable object of the <CODE>Key</CODE> type.
     */
    public Key getPrivateKey() {
	// BigInteger n2 = ((RSAPrivateKey) kp.getPrivate()).getModulus();
	// BigInteger d =  ((RSAPrivateKey) kp.getPrivate()).getPrivateExponent();
	//Key privKey = new Key(n2, d);
	//return privKey;
	
	return new RsaKey((RSAPrivateKey) (kp.getPrivate()));
    }	
	


    /**
     * This method erase the public and private keys stored in the
     * <CODE>CryptoSystem</CODE> object. It prevents the keys of being stolen
     * after they have been created.
     */
    public void reset() {
	kpg = null;
	map = null;
	kp = null;
   }
}
