package arcademis.security;

/**
 * This interface determines the factory of connection servers. This factory is
 * reponsible for the creation of these components. If the connection server is going to
 * be changed, it suffices to exchange the old factory by a new one, that
 * create the new component. The other parts of the middleware usually do not
 * have to be modified.
 */
public interface CryptoSystemFc {

	/**
	 * Returns a new instance of the cryptosystem factory.
	 * @return an object of the <CODE>CryptoSystem</CODE> type.
	 */
	public CryptoSystem createCryptoSystem ();

	/**
	 * Returns a new instance of the cryptosystem factory.
	 * @return an object of the <CODE>CryptoSystem</CODE> type.
	 * @param objType the type of factory that should be created.
	 */
	public CryptoSystem createCryptoSystem (int objType);
}
