package arcademis.security;

import java.util.Date;

import arcademis.Stream;
import arcademis.Marshalable;
import arcademis.MarshalException;

public class Certificate implements Marshalable {

    private String name = null;

    private Date timeStamp = null;

    private Key publicKey = null;

    public Certificate() {
        name = "ANONYMOUS";
        timeStamp = new Date();
        publicKey = null;
    }

    public Certificate(String name, Date timeStamp, Key publicKey) {
        this.name = name;
        this.timeStamp = timeStamp;
        this.publicKey = publicKey;
    }

    public String getName() {
        return this.name;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Key getPublicKey() {
        return this.publicKey;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setPublicKey(Key publicKey) {
        this.publicKey = publicKey;
    }

    public String toString() {
        return "Digital certificate:\n" +
               "Owner: " + this.name + '\n' +
               "Time stamp: " + this.timeStamp + '\n' +
               "Public key: " + this.publicKey;
    }

    /**
     * This method determines how the internal state of the object will be
     * transcripted to a raw sequence of bytes.
     * @param b the <CODE>Stream</CODE> that will receive the data that
     * constitutes the current's object internal state.
     * @throws MarshalException if the serialization process cannot be
     * completed.
     */
    public void marshal(Stream b) throws MarshalException {
        b.write(this.name);
        b.write(this.publicKey);
        b.write(this.timeStamp.getTime());
    }

    /**
     * This method defines how the content of the key can be retrieved from a
     * raw sequence of bytes.
     * @param b the <CODE>Stream</CODE> that will be read so that the new
     * content of the object can be obtained.
     * @throws MarshalException if the serialization process cannot be
     * completed.
     */
    public void unmarshal(Stream b) throws MarshalException {
        this.name = (String)b.readObject();
        this.publicKey = (Key)b.readObject();
        this.timeStamp = new Date(b.readLong());
    }

}
