package arcademis.security;

import arcademis.Marshalable;

public interface ArcademisKey extends Marshalable {
    /**
     * This method encypher an array of bytes using the given key. For example,
     * in order to send a signed, secret message, the message can be signed with
     * the public key of the receiver, and the private key of the sender.
     * @param message the set of bytes that will be encrypted.
     * @return the encrypted message.
     */
    byte[] encrypt(byte[] message);

    /**
     * This method is the inverse function of the <CODE>encryp</CODE> operation.
     * Given a cypher, and a key, it will apply the reverse function in order to
     * recover the original message.
     * @param message the set of bytes that will be decyphered.
     * @return the decrypted message.
     */
    byte[] decrypt(byte[] message);
}
