package arcademis;

/**
 * This exception is thrown whenever an attempt to reconfigure the ORB is
 * performed, but the ORB is closed for reconfigurations. Generally, after
 * determining the set of factories that composes the ORB, the application
 * close it for further reconfigurations, so that it does not need to care
 * about dynamic changes in the middleware behavior.
 */
public class ReconfigurationException extends ArcademisException {
	/**
	 * Empty constructor. Puts a standard message into the error stack.
	 */
	public ReconfigurationException() {
		super("Attempt to reconfigure ORB close of reconfiguration");
	}

	/**
	 * This constructor inserts the given message into the error queue.
	 * @param msg the message to be inserted into the queue.
	 */
	public ReconfigurationException(String msg) {
		super(msg);
	}
}
