package arcademis;

/**
 * This exception is thrown when a failure in the middleware protocol is
 * perceived. Such failures happen, for example, when a given message is being
 * expected and another one is actually received.
 */
public class ProtocolException extends ArcademisException {
	/**
	 * Empty constructor. Puts a standard message into the error stack.
	 */
	public ProtocolException() {
		super("Protocol exception: wrong message type");
	}

	/**
	 * This constructor inserts the given message into the error queue.
	 * @param msg the message to be inserted into the queue.
	 */
	public ProtocolException(String msg) {
		super(msg);
	}
}
