package arcademis;

/**
 * This exception indicates that an error has occurred while data was being
 * transmitted across the network. Such erros may happen, for example, when an
 * attempt to contact an of-line server takes place.
 */
public class NetworkException extends ArcademisException {
	/**
	 * Empty constructor. Puts a standard message in the error stack.
	 */
	public NetworkException() {
		super("Error: network exception");
	}

	/**
	 * This constructor inserts the given message into the error queue.
	 * @param msg the message to be inserted into the queue.
	 */
	public NetworkException(String msg) {
		super(msg);
	}
}
