package arcademis;

/**
 * This exception indicates that an error in the serialization process has
 * occurred. Generally, such erros are given by attempts to read data from an
 * empty stream or by attempts to read data by means of the wrong reading
 * method.
 */
public class MarshalException extends ArcademisException {
	/**
	 * Empty constructor. Puts a standard message in the error stack.
	 */
	public MarshalException() {
		super("Error: marshal exception");
	}

	/**
	 * This constructor inserts the given message into the error queue.
	 * @param msg the message to be inserted into the queue.
	 */
	public MarshalException(String msg) {
		super(msg);
	}
}
