package arcademis;

/**
 * This exception indicates that the server has received a remote method
 * invocation that has not been issued by a stub generated by the remote
 * object the message targets.
 */
public class IncompatibleStubException extends ArcademisException {

	/**
	 * Empty constructor. Puts a standard message in the error stack.
	 */
	public IncompatibleStubException() {
		super("Attempt to use wrong stub in communication with remote object");
	}

	/**
	 * This constructor inserts the given message into the error queue.
	 * @param msg the message to be inserted into the queue.
	 */
	public IncompatibleStubException(String msg) {
		super(msg);
	}
}