package arcademis;

/**
 * This exception indicates that an error has occurred during buffer
 * manipulation. Such erros can be, for example, an attempt to insert data into
 * a buffer completly full, or to retrieve data from an empty buffer.
 */
public class BufferException extends ArcademisException {
	/**
	 * Empty constructor. Puts a standard message in the error stack.
	 */
	public BufferException() {
		super("Exception in buffer");
	}

	/**
	 * This constructor inserts the given message into the error queue.
	 * @param msg the message to be inserted into the queue.
	 */
	public BufferException(String msg) {
		super(msg);
	}
}