package CFGV;

import joeq.Compiler.Quad.*;
import joeq.Compiler.Quad.SSA.*;
import joeq.Compiler.Dataflow.*;
import joeq.Main.Helper;
import joeq.Class.*;
import joeq.Util.Templates.*;

public class PhiDestructor {
    ControlFlowGraph cfg = null;

    public PhiDestructor(ControlFlowGraph cfg) {
        this.cfg = cfg;
    }

    public ControlFlowGraph getCFG() {
        return this.cfg;
    }

    /**
     * This method converts the encapsulated graph to SSA representation.
     * In this representation, every variable is defined just once.
     */
    public void convertSSA() {
        EnterSSA.markSSARegisterFlags(this.cfg);
        EnterSSA essa = new EnterSSA();
        essa.visitCFG(this.cfg);
    }


    /**
     * Basically the method remove phi functions from a basic block, and inserts
     * move instructions on its successors.
     */
    public void handleBasicBlock(BasicBlock bb) {
        java.util.LinkedList phiQuads = new java.util.LinkedList();
        ListIterator.Quad qIter = bb.iterator();
        while(qIter.hasNext()) {
            Quad quad = qIter.nextQuad();
            Operator op = quad.getOperator();
            if(op instanceof Operator.Phi.PHI) {
                Operator.Phi.PHI phi = (Operator.Phi.PHI)op;
                Operand.RegisterOperand dest = Operator.Phi.PHI.getDest(quad);
                UnmodifiableList.RegisterOperand uReg = phi.getUsedRegisters(quad);
                Operand.BasicBlockTableOperand pred = Operator.Phi.PHI.getPreds(quad);
                for(int i = 0; i < uReg.size(); i++) {
                    // get source register: src
                    Operand.RegisterOperand src = Operator.Phi.PHI.getSrc(quad, i);
                    // add move dest src to predBlock
                    Quad move = Operator.Move.create(this.cfg.getNewQuadID(), dest.getRegister(), src.getRegister(), src.getType());
                    // get the block that originates src: predBlock
                    BasicBlock predBlock = Operator.Phi.PHI.getPred(quad, i);
                    predBlock.appendQuad(move);

                    // remove the phi function
                    phiQuads.add(quad);
                }
            }
        }
        while(phiQuads.size() > 0) {
            Quad quad = (Quad)phiQuads.removeFirst();
            bb.removeQuad(quad);
        }
    }


    /**
     * Destroy the phi functions, by replacing them for move instructions, in
     * each basic block.
     */
    public void destroyPhiFunctions() {
        ListIterator.BasicBlock bbIterator = this.cfg.postOrderOnReverseGraphIterator();
        while(bbIterator.hasNext()) {
            BasicBlock bb = bbIterator.nextBasicBlock();
            handleBasicBlock(bb);
        }
    }

}
