package CFGV;

import java.io.PrintWriter;
import java.io.PrintStream;
import jwutil.math.BitString;

/**
 * This interface represents a node in the control flow. Different types
 * of nodes should implement different printing methods. For example,
 * in order to draw a branch, normally a diamond should be used. On
 * the other hand, in order to draw an ordinary basic block, it is better
 * to use a simple box.
 * The printing method must generate code for a block in .dot format.
 * In order to be more flexible, this interface uses two different kinds of
 * output, a print stream, and a print writer.
 */
public interface CfgNode {

    /**
     * This method prints code for a block in the given output.
     * @param out the output device.
     */
    public void printNode(PrintStream out);

    /**
     * This method prints code for all the edges that are reaching this node.
     * The label of the edges contains the liveness information of the basic
     * block.
     * @param out the output device.
     * @param bs a vector containing liveness information.
     */
    public void printEdges(PrintStream out, BitString bs);

    /**
     * This method prints code for a block in the given file.
     * @param out the output file.
     */
    public void printNode(PrintWriter out);

    /**
     * This method prints code for all the edges that are reaching this node in
     * the given file.
     * The label of the edges contains the liveness information of the basic
     * block.
     * @param out the output file.
     * @param bs a vector containing liveness information.
     */
    public void printEdges(PrintWriter out, BitString bs);
}
